/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.init;

import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.lib.item.ItemPredicate;
import com.technicalitiesmc.lib.item.TKItem;
import com.technicalitiesmc.lib.item.ifo.IFOStorage;
import com.technicalitiesmc.lib.util.AccurateTime;
import com.technicalitiesmc.lib.util.DyeHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class TKLibCapabilities {
    private static final ResourceLocation CLIENT_ACCURATE_TIME_NAME = new ResourceLocation("tklib", "client_accurate_time");
    private static final ResourceLocation IFO_STORAGE_NAME = new ResourceLocation("tklib", "item_functional_override");
    private static final Capability<AccurateTime> ACCURATE_TIME_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<AccurateTime>(){});
    private static final Capability<IFOStorage> IFO_STORAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFOStorage>(){});

    public static void onCapabilityRegistration(RegisterCapabilitiesEvent event) {
        event.register(TKItem.DataStore.class);
        event.register(ComponentPlacement.class);
        event.register(DyeHolder.class);
        event.register(AccurateTime.class);
        event.register(ItemPredicate.class);
        event.register(IFOStorage.class);
    }

    public static void onAttachLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        if (((Level)event.getObject()).m_5776_()) {
            LazyOptional value = LazyOptional.of(() -> new AccurateTime.Client());
            TKLibCapabilities.attachCapability(event, CLIENT_ACCURATE_TIME_NAME, ACCURATE_TIME_CAPABILITY, value);
        }
    }

    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            LazyOptional value = LazyOptional.of(IFOStorage::new);
            TKLibCapabilities.attachCapability(event, IFO_STORAGE_NAME, IFO_STORAGE_CAPABILITY, value);
        }
    }

    private static <T> void attachCapability(AttachCapabilitiesEvent<?> event, ResourceLocation name, final Capability<T> capability, final LazyOptional<? extends T> value) {
        event.addCapability(name, new ICapabilityProvider(){

            @Nonnull
            public <V> LazyOptional<V> getCapability(@Nonnull Capability<V> cap, @Nullable Direction side) {
                if (cap == capability) {
                    return value.cast();
                }
                return LazyOptional.empty();
            }
        });
        event.addListener(() -> value.invalidate());
    }
}

